; Div UPs

.include "allgdef.inc"

.global Ziffertest,Holepos,Asciihex,Holers232adresse,Zeichnelinie
.global	Ydrehen,Ydrehenlinie,Holefont1,Holefont2,Holefont3,Holefont4
.global	Tftclr,Holefarbe

; -------------------------------------------------
; Testet ob es eine ASCII-Ziffer ist
; Eingang: w0
; Ausgang: z=1 wenn OK
; -------------------------------------------------
Ziffertest:
	ze		w0,w0
	mov		#'0',w1
	cp		w0,w1
	bra		lt,ztest1		; zu klein!
	mov		#'9',w1
	cp		w0,w1
	bra		gt,ztest1		; zu gross!
	cp0		w0
	return
ztest1:
	clr		w0
	cp0		w0
	reset

; -------------------------------------------------
; erzeugt von 3 Dez-Ziffern ein Positions-Word
; Eingang: (D)pospuffer
; Ausgang: w1
; -------------------------------------------------
 Holepos:
 	mov		pospuffer,w1
 	mov		pospuffer+2,w2
 	mov		pospuffer+4,w3
	call	Asciihex
	return
	
; -------------------------------------------------
; Asciihex 
; Eingang: 3 Ascii-Zifffer von "000" bis max "480" in w1,w2,w3
; Ausgang: 16bit-word in w1
; -------------------------------------------------
Asciihex:
	and		#0b00001111,w1		; HW
	and		#0b00001111,w2
	and		#0b00001111,w3		; NW
	mul.uu	w2,#10,w4			; w2 x 16 = w4,w5
	add		w4,w3,w3
	mov		#100,w2
	mul.uu	w1,w2,w4			; w1 x 256 = w4,w5
	add		W4,w3,w1
	return						; Ergebnis in w1
; -------------------------------------------------
; holt aktuelle Adresse fr neues Byte im Ringpuffer
; -------------------------------------------------
; es gibt 2 Zeiger:
; (D)rspuffer1 (= Anfang) und rspuffer2 (= Ende); wenn beide identisch sind
; ist der Puffer leer. Die Adresse wird in w7 bergeben.
; Ist der Puffer leer oder das Byte darin gelscht (0x00) wird w7 mit 0x00
; bergeben. 
; Der Aufrufer muss das entnommene Byte im Puffer lschen.
Holers232adresse:
	mov		rspufferzgr2,wreg
	cp		rspufferzgr1
	bra		nz,holers1
	clr		w7					; Puffer leer
	return
holers1:
	mov		w0,w7
	cp0.b		[w7]
	bra		nz,holers2
	clr		w7					; Byte = 0x00
holers2:
	inc		rspufferzgr2
	btss	rspufferzgr2,#9
	return
holers3:
	mov		#rs232cpuffer,w1
	mov		w1,rspufferzgr2
	return
		
; -------------------------------------------------
; Linie bzw Rechteck zwichnen un mit Hintergrundfarbe fllen
; -------------------------------------------------
; Eingang: Textstring xxx,yyy in [w7]
Zeichnelinie:
 	mov		[w7++],w1
 	mov		[w7++],w2
 	mov		[w7++],w3
	call	Asciihex
	mov		w1,linienbreite
 	mov		[w7++],w1
 	mov		[w7++],w2
 	mov		[w7++],w3
	call	Asciihex
	mov		w1,linienhoehe
	call	Ydrehenlinie
	mov		#3,w0
	mov		w0,lcdsta
	bset  	merker,#lcdaktiv
	return

; -------------------------------------------------
; ist fr das rote TFT-Modul ntig weil unten links = 0,0
; beim blauen TFT-Modul darf nicht verwendet werden weil oben links = 0,0
; -------------------------------------------------
Ydrehen:
	btsc	merker,#tftrevers
	bra		ynichtdrehen
	mov		rsypos,w1
	mov		#320,w2
	sub		w2,w1,w1
	mov		fonthoehe,w2
	sub		w1,w2,w1
	mov		w1,ypos
	return
Ydrehenlinie:
	btsc	merker,#tftrevers
	bra		ynichtdrehen
	mov		rsypos,w1
	mov		#320,w2
	sub		w2,w1,w1
	mov		linienhoehe,w2
	sub		w1,w2,w1
	mov		w1,ypos
	return	
ynichtdrehen:
	mov		rsypos,w0
	mov		w0,ypos
	return		

; -------------------------------------------------
; Font-daten holen
; -------------------------------------------------

; Font #1 12x16
Holefont1:
	mov		#12,w1
	mov		w1,fontbreite
	mov		#16,w1
	mov		w1,fonthoehe
 	mov		#psvoffset(font12x16),w1
	mov		w1,fontadresse
	mov		#32,w1
	mov		w1,adressenoffset
	mov		#12,w1
	mov		w1,bitzaehler
	mov		#1,w1
	mov		w1,schriftgroesse
	mov		#3,w1
	mov		w1,minifont
	return
	
; Font #2 16x26
Holefont2:
 	mov		#16,w1
	mov		w1,fontbreite
	mov		#26,w1
	mov		w1,fonthoehe
 	mov		#psvoffset(font16x26),w1
	mov		w1,fontadresse
	mov		#52,w1
	mov		w1,adressenoffset
	mov		#16,w1
	mov		w1,bitzaehler
	mov		#1,w1
	mov		w1,schriftgroesse
	clr		minifont
	return

; Font #3 12x16x2
Holefont3:
	mov		#24,w1
	mov		w1,fontbreite
	mov		#32,w1
	mov		w1,fonthoehe
 	mov		#psvoffset(font12x16),w1
	mov		w1,fontadresse
	mov		#32,w1
	mov		w1,adressenoffset
	mov		#12,w1
	mov		w1,bitzaehler
	mov		#2,w1
	mov		w1,schriftgroesse
	mov		#3,w1
	mov		w1,minifont
	return
	
; Font #4 16x26x2
Holefont4:
	mov		#32,w1
	mov		w1,fontbreite
	mov		#52,w1
	mov		w1,fonthoehe
 	mov		#psvoffset(font16x26),w1
	mov		w1,fontadresse
	mov		#52,w1
	mov		w1,adressenoffset
	mov		#16,w1
	mov		w1,bitzaehler
	mov		#2,w1
	mov		w1,schriftgroesse
	clr		minifont
	return

; -------------------------------------------------
; TFT komplett beschreiben mit Einer Farbe
; Eingang: farbe in (D)hintergrund
; -------------------------------------------------
Tftclr:
	clr		xpos
	clr		ypos
	mov		#320,w1
	mov		w1,linienhoehe
	mov		#48,w1
	mov		w1,linienbreite
	call	Clrzumtft
	nop
	do		#9,tftclr1
	mov		xpos,w1
	add		#48,w1
	mov		w1,xpos
	call	Clrzumtft
	nop
tftclr1:
	nop
	nop
	return

Clrzumtft:
	mov		#3,w1
	mov		w1,lcdsta
	bset	merker,#lcdaktiv
clrzumtft1:
	call	Lcdbed
	nop
	btsc	merker,#lcdaktiv
	bra		clrzumtft1
	return

; -------------------------------------------------
; holt die Farbe, Festwert 0 bis 8, w0 >> w0
; -------------------------------------------------

Holefarbe:
	bra		 w12
	bra		holef0
	bra		holef1
	bra		holef2
	bra		holef3
	bra		holef4
	bra		holef5
	bra		holef6
	bra		holef7
	bra		holef8
	return
holef0:
	mov		#schwarz,w0
	return
holef1:
	mov		#weiss,w0
	return
holef2:
	mov		#rot,w0
	return
holef3:
	mov		#hellrot,w0
	return
holef4:
	mov		#gruen,w0
	return
holef5:
	mov		#gelb,w0
	return
holef6:
	mov		#blau,w0
	return
holef7:
	mov		#cyan,w0
	return
holef8:
	mov		#lila,w0
	return

